//+------------------------------------------------------------------+
//|                                                  CM_Strength.mq4 |
//|                        Copyright 2017, MetaQuotes Software Corp. |
//|                                             https://www.mql5.com |
//+------------------------------------------------------------------+
#property copyright "GVC"
#property link      "https://www.mql5.com"
#property version   "1.00"
#property strict
#property indicator_chart_window

sinput   ENUM_TIMEFRAMES         csm1        = PERIOD_D1;         // TimeFrame 1 for CSM
sinput   ENUM_TIMEFRAMES         csm2        = PERIOD_H4;          // TimeFrame 2 for CSM
sinput   ENUM_TIMEFRAMES         csm3        = PERIOD_H1;          // TimeFrame 3 for CSM
sinput   ENUM_TIMEFRAMES         csm4        = PERIOD_M30;          // TimeFrame 4 for CSM
sinput   ENUM_TIMEFRAMES         csm5        = PERIOD_M15;          // TimeFrame 5 for CSM
sinput int                       x_axis                    =0;
sinput int                       y_axis                    =20;

string TXT = "CM_BR";
string DefaultPairs[] = {"AUDCAD","AUDCHF","AUDJPY","AUDNZD","AUDUSD","CADCHF","CADJPY","CHFJPY","EURAUD","EURCAD","EURCHF","EURGBP","EURJPY","EURNZD","EURUSD","GBPAUD","GBPCAD","GBPCHF","GBPJPY","GBPNZD","GBPUSD","NZDCAD","NZDCHF","NZDJPY","NZDUSD","USDCAD","USDCHF","USDJPY"};
string TradePairs[];
string curr[8] = {"USD","EUR","GBP","JPY","AUD","NZD","CAD","CHF"};

double currstrength[8];

string postfix=StringSubstr(Symbol(),6,6);

struct pairinf {
   double PairPip;
   int pipsfactor;
   double Pips;
   double PipsSig;
   double Pipsprev;
   double Spread;
   double point;
   int lastSignal;
   int    base;
   int    quote;   
}; pairinf pairinfo[];

struct currency 
  {
   string            curr;
   double            strength;
   double            prevstrength;
   double            crs;
   int               sync;
   datetime          lastbar;
  }
; currency currencies[8];

struct signal { 
   string symbol;
   double range;
   double range1;
   double ratio;
  
   
}; signal signals[];

int CandlePeriod;
string timer1,timer2,timer3,timer4,timer5;
int AutoTimer=5;
//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int OnInit()
  {
//--- indicator buffers mapping
  string s;
  string name;
    s = TXT; //_symbolPair;
    //s = Symbol();
    for (int i = ObjectsTotal() - 1; i >= 0; i--)
    {
        name = ObjectName(i);
        if (StringSubstr(name, 0, StringLen(s)) == s)
        {
            ObjectDelete(name);
        }
    } 
   
      ArrayCopy(TradePairs,DefaultPairs);
       
  for (int i=0;i<8;i++)
      currencies[i].curr = curr[i]; 
   
   if (ArraySize(TradePairs) <= 0) {
      Print("No pairs to trade");
      return(INIT_FAILED);
   }
   
   ArrayResize(pairinfo,ArraySize(TradePairs));
   ArrayResize(signals,ArraySize(TradePairs));
          
    for(int i=0;i<ArraySize(TradePairs);i++){
    TradePairs[i]=TradePairs[i]+postfix;
    signals[i].symbol=TradePairs[i];    

    
      if (MarketInfo(TradePairs[i] ,MODE_DIGITS) == 4 || MarketInfo(TradePairs[i] ,MODE_DIGITS) == 2) {
         pairinfo[i].PairPip = MarketInfo(TradePairs[i] ,MODE_POINT);
         pairinfo[i].pipsfactor = 1;
      } else { 
         pairinfo[i].PairPip = MarketInfo(TradePairs[i] ,MODE_POINT)*10;
         pairinfo[i].pipsfactor = 10;
      }
 
   }



   EventSetTimer(1);




//---
   return(INIT_SUCCEEDED);
  }
//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int OnCalculate(const int rates_total,
                const int prev_calculated,
                const datetime &time[],
                const double &open[],
                const double &high[],
                const double &low[],
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int &spread[])
  {
//---
   
//--- return value of prev_calculated for next call
   return(rates_total);
  }
  
  
  //+------------------------------------------------------------------+
//| Expert deinitialization function                                 |
//+------------------------------------------------------------------+
void OnDeinit(const int reason)
  {
   string s;
  string name;
    s = TXT; //_symbolPair;
    //s = Symbol();
    for (int i = ObjectsTotal() - 1; i >= 0; i--)
    {
        name = ObjectName(i);
        if (StringSubstr(name, 0, StringLen(s)) == s)
        {
            ObjectDelete(name);
        }
    } 
//--- destroy timer
   EventKillTimer();
   //ObjectsDeleteAll();
      
  }

//+------------------------------------------------------------------+
//| Timer function                                                   |
//+------------------------------------------------------------------+
void OnTimer()
  {
//---
   if(csm1>0) CandlePeriod=csm1;
   GetSignals(StrToTime(timer1),100,0);
   if(csm2>0) CandlePeriod=csm2;
   GetSignals(StrToTime(timer2),180,0);
   if(csm3>0) CandlePeriod=csm3;
   GetSignals(StrToTime(timer3),260,0);
   if(csm4>0) CandlePeriod=csm4;
   GetSignals(StrToTime(timer4),340,0);
   if(csm5>0) CandlePeriod=csm5;
   GetSignals(StrToTime(timer5),420,0);
  }
//+------------------------------------------------------------------+
//| ChartEvent function                                              |
//+------------------------------------------------------------------+
void OnChartEvent(const int id,
                  const long &lparam,
                  const double &dparam,
                  const string &sparam)
  {
//---
   
  }
//+------------------------------------------------------------------+
void GetSignals(datetime timer,int xdistt,int ydistt)
  {
   
     SetText(TXT+(string) xdistt+"TF",GetHeader(),xdistt+x_axis+20,y_axis-15,clrYellow,9);
     SetPanel(TXT+(string) xdistt+"Panel",0,xdistt+x_axis-10, y_axis-20 ,80,150,clrBlack,clrWhiteSmoke,3);
    
     double arrt[8][2];
      for(int a=0;a<8;a++)
     {
     
      arrt[a][0] = currency_strength(curr[a]);
      arrt[a][1] = a;
      
     }
     ArraySort(arrt,WHOLE_ARRAY,0,MODE_DESCEND);
         
     for(int u=0; u<8; u++)
        
      { 
     int arr2=arrt[u][1];
     string ss=curr[arr2];      
     
     SetText(TXT+(string)xdistt+"Curr"+IntegerToString(u),ss,xdistt+x_axis,(u*15)+y_axis,color_for_profit(arrt[u][0]),10);
     SetText(TXT+(string)xdistt+"currM"+IntegerToString(u),DoubleToStr(arrt[u][0],0),xdistt+x_axis+40,(u*15)+y_axis,color_for_profit(arrt[u][0]),10); 
         
      }        
 
}     
//+------------------------------------------------------------------+
color color_for_profit(double total) 
  {
   if(total<20.0)
      return (clrRed);
   if(total<=30.0)
      return (clrOrangeRed);
   if(total>70.0)
      return (clrLime);
   if(total>60.0)
      return (clrGreen);
   if(total>50.0)
      return (clrSandyBrown);
   if(total<=50.0)
      return (clrYellow);       
   return(clrSteelBlue);
  }
//-------------------------------------------------------------------+
string GetHeader()
{
  if( CandlePeriod < 60 ) return( "M"+ string (CandlePeriod));
  if( CandlePeriod < 1440 ) return( "H"+ string(CandlePeriod / 60.0));
  if( CandlePeriod < 10080 ) return( "D"+ string(CandlePeriod / 60.0 / 24));
  if( CandlePeriod < 43200 ) return( "W"+ string(CandlePeriod / 60.0 / 24 / 7));
  return( "MN1");
}
//-------------------------------------------------------------------+
double currency_strength(string pair)
 {
   string sym;
   double range;
   double ratio;
   double strength=0;
   int    cnt1=0;

   for(int x=0; x<ArraySize(TradePairs); x++) 
     {
     // fact= 0;
      sym = TradePairs[x];
      if(pair==StringSubstr(sym,0,3) || pair==StringSubstr(sym,3,3)) 
        {
         
         range=(iHigh(sym,CandlePeriod,0)-iLow(sym,CandlePeriod,0));
         if(range!=0.0) 
           {
            ratio=MathMin(100.0 *((MarketInfo(sym,MODE_BID)-iLow(sym,CandlePeriod,0))/range),100);            
            cnt1++;
          if(pair==StringSubstr(sym,3,3))ratio = 100 - ratio;
               //fact=9-fact; 
            strength+=ratio;
           }
        }

     }
   if(cnt1!=0)strength/=cnt1;
   return (strength);

   
 }
//-----------------------------------------------------------------------------------+
void SetText(string name,string text,int x,int y,color colour,int fontsize=10)
  {
   if (ObjectFind(0,name)<0)
      ObjectCreate(0,name,OBJ_LABEL,0,0,0);

    ObjectSetInteger(0,name,OBJPROP_XDISTANCE,x);
    ObjectSetInteger(0,name,OBJPROP_YDISTANCE,y);
    ObjectSetInteger(0,name,OBJPROP_COLOR,colour);
    ObjectSetInteger(0,name,OBJPROP_FONTSIZE,fontsize);
    ObjectSetInteger(0,name,OBJPROP_CORNER,CORNER_LEFT_UPPER);
    ObjectSetString(0,name,OBJPROP_TEXT,text);
  } 
  
  //+------------------------------------------------------------------+

void SetObjText(string name,string CharToStr,int x,int y,color colour,int fontsize=12)
  {
   if(ObjectFind(0,name)<0)
      ObjectCreate(0,name,OBJ_LABEL,0,0,0);

   ObjectSetInteger(0,name,OBJPROP_FONTSIZE,fontsize);
   ObjectSetInteger(0,name,OBJPROP_COLOR,colour);
   ObjectSetInteger(0,name,OBJPROP_BACK,false);
   ObjectSetInteger(0,name,OBJPROP_XDISTANCE,x);
   ObjectSetInteger(0,name,OBJPROP_YDISTANCE,y);
   ObjectSetString(0,name,OBJPROP_TEXT,CharToStr);
   ObjectSetString(0,name,OBJPROP_FONT,"Wingdings");
  } 
//-----------------------------------------------------------------------+
void SetPanel(string name,int sub_window,int x,int y,int width,int height,color bg_color,color border_clr,int border_width)
  {
   if(ObjectCreate(0,name,OBJ_RECTANGLE_LABEL,sub_window,0,0))
     {
      ObjectSetInteger(0,name,OBJPROP_XDISTANCE,x);
      ObjectSetInteger(0,name,OBJPROP_YDISTANCE,y);
      ObjectSetInteger(0,name,OBJPROP_XSIZE,width);
      ObjectSetInteger(0,name,OBJPROP_YSIZE,height);
      ObjectSetInteger(0,name,OBJPROP_BGCOLOR,bg_color);
      ObjectSetInteger(0,name,OBJPROP_BORDER_TYPE,BORDER_FLAT);
      ObjectSetInteger(0,name,OBJPROP_WIDTH,border_width);
      ObjectSetInteger(0,name,OBJPROP_CORNER,CORNER_LEFT_UPPER);
      //ObjectSetInteger(0,name,OBJPROP_STYLE,STYLE_SOLID);
      ObjectSetInteger(0,name,OBJPROP_BACK,true);
      ObjectSetInteger(0,name,OBJPROP_SELECTABLE,0);
      ObjectSetInteger(0,name,OBJPROP_SELECTED,0);
      //ObjectSetInteger(0,name,OBJPROP_HIDDEN,true);
      ObjectSetInteger(0,name,OBJPROP_ZORDER,0);
     }
   ObjectSetInteger(0,name,OBJPROP_BGCOLOR,bg_color);
  }